Attribute VB_Name = "Module1"
Option Explicit
'' """""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
''    Copyright  2002 Agilent Technologies Inc. All rights
''    reserved.
''
'' You have a royalty-free right to use, modify, reproduce and distribute
'' the Sample Application Files (and/or any modified version) in any way
'' you find useful, provided that you agree that Agilent has no
'' warranty,  obligations or liability for any Sample Application Files.
''
'' Agilent Technologies provides programming examples for illustration only,
'' This sample program assumes that you are familiar with the programming
'' language being demonstrated and the tools used to create and debug
'' procedures. Agilent support engineers can help explain the
'' functionality of Agilent software components and associated
'' commands, but they will not modify these samples to provide added
'' functionality or construct procedures to meet your specific needs.
'' """"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""

Public Function isconnected(io As Agt3494A) As Boolean
    ' determines if the instrument is connected, and
    ' gives a message if not
    Dim result(4) As String
    Dim module As String
    Dim oldTimeout As Long
    Dim slotNumber As String
    Dim cmd As String

    On Error GoTo connectError

    With io
        oldTimeout = .Timeout
        .Output "*IDN?"
        .Timeout = 1000
        .Enter result
        .Timeout = oldTimeout
    End With

    If InStr(1, result(1), "34970", vbTextCompare) = 0 Then
        GoTo WrongInstrumentError
    End If

    isconnected = True

    Exit Function

connectError:
    io.Timeout = 10000
    MsgBox "Instrument not connected. Please check connections and set the GPIB address in the 3494A control properties."
    isconnected = False
    Exit Function
WrongInstrumentError:
    MsgBox "Incorrect instrument: " & vbCrLf & _
            "Expected 34970A " & vbCrLf & _
            "Instrument discovered: " & result(1)
    isconnected = False
    Exit Function

End Function

Public Function InstrumentError(io As Agt3494A) As Boolean
    Dim reply As String

    With io
        .Output "Syst:Error?"
        .Enter reply
    End With

    If Val(reply) <> 0 Then
        InstrumentError = True
        MsgBox "Instrument Error: " & vbCrLf & reply, vbCritical
        InstrumentError io
    Else
        InstrumentError = False
    End If

End Function

Public Sub ReadSlots(io As Agt3494A, cboSlot As ComboBox)
    ' read the slots and put into the dropdown
    Dim module As String
    Dim i As Long

    On Error GoTo ErrReadSlot
    '
    ' Add more slots for different instruments
    If isconnected(io) Then
        cboSlot.Clear
        cboSlot.AddItem "1-" & ModuleName(io, "100")
        cboSlot.AddItem "2-" & ModuleName(io, "200")
        cboSlot.AddItem "3-" & ModuleName(io, "300")
    End If
    
    ' select the MUX card if it exists
    cboSlot.ListIndex = 0
    For i = 0 To cboSlot.ListCount - 1
        If InStr(1, cboSlot.List(i), "34901A", vbTextCompare) Or _
        InStr(1, cboSlot.List(i), "34902A", vbTextCompare) Then
            cboSlot.ListIndex = i
            Exit For
        End If
    Next i

ErrReadSlot:

End Sub

Private Function ModuleName(io As Agt3494A, ByVal slot As String) As String
    ' Gets the module model number for a given slot
    Dim result(4) As String

    With io
        .Output "System:CType? " & slot
        .Enter result
        If Len(result(1)) < 3 Then
            ModuleName = "Empty"
        Else
            ModuleName = result(1)
        End If
    End With
    InstrumentError io

End Function


